/* Modified to eliminate status messages */
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Must use Linux specific fcntl header.
#include </usr/include/linux/fcntl.h>

int main(int argc, char *argv[]) {
	int verbose = 0;
	int opt;
	int arg;
	char use[120];
	char fifo[120];
	long size;
	sprintf(use, "Usage: %s [-v(erbose)] <fifo> <size in Mb>\nSet fifo buffer size\n", argv[0]);

	while (( opt = getopt (argc, argv, "v")) != -1)
		switch (opt) {
			case 'v': verbose = 1; break;
			default: printf ("%s", use); return 1;
		}

	if ((argc-optind) != 2) { printf ("%s", use); return 1; }

	sprintf(fifo, "%s", argv[optind]);
	size = ( atoi(argv[optind+1]) * (1024 * 1024) );
	if (size <= 0) { perror("pipe size is not valid!"); return 1; }

	// The specified file should be a fifo.
	int fd = open(fifo, O_RDONLY);
	if (fd < 0) { perror("open fifo failed!"); return 1; }

	int ret = fcntl(fd, F_SETPIPE_SZ, size);
	if (ret < 0) { perror("set fifo size failed!"); }

	if (verbose > 0) {
		long fifo_size = (long)fcntl(fd, F_GETPIPE_SZ);
		if (fifo_size == -1) { perror("get fifo size  failed!"); }
		printf("'%s' fifo size: %ld\n", fifo, fifo_size);
	}

	close(fd);
}
