#!/bin/sh
# Copyright (c) 2017-2019 by Pulse Secure, LLC. All rights reserved

set -e

cleanup() {
if [ -d "../pulsePsal" ]
then
        rm -rf ../pulsePsal
fi
}


trap cleanup EXIT

mkdir -p pulsePsal
dpkg-deb -x PulseSecureAppLauncher.deb pulsePsal

cd pulsePsal
cd ./opt/psallinux/bin/
./verifyUtil ../cert/domain.crt psallinux

mkdir -p $HOME/.mozilla/native-messaging-hosts
cd ../../../
mv ./opt/psallinux/doc/psallinux.json $HOME/.mozilla/native-messaging-hosts/
sed -i "s@USR_PATH@$HOME@" $HOME/.mozilla/native-messaging-hosts/psallinux.json

if [ ! -d $HOME/psallinux/bin ]; then
mkdir -p $HOME/psallinux/bin
fi
if [ ! -d $HOME/psallinux/cert ]; then
mkdir -p $HOME/psallinux/cert
fi
mv ./opt/psallinux/bin/version.ini $HOME/psallinux/bin/

mv ./opt/psallinux/bin/psallinux $HOME/psallinux/bin/

mv ./opt/psallinux/cert/domain.crt $HOME/psallinux/cert/domain.crt

